// 加载 JSON
const modbus = JSON.parse(window.api.loadJSON('Modbus-RTU.json'));
const tcp    = JSON.parse(window.api.loadJSON('TCP.json'));
const data   = { ...modbus, ...tcp };

const tabs     = document.querySelectorAll('.tab-btn');
const content  = document.getElementById('content');
const exportBtn= document.getElementById('exportBtn');
let currentTab = 'config';

// 渲染函数
function render() {
  content.innerHTML = '';
  if (currentTab === 'config') renderConfig();
  if (currentTab === 'nodes')  renderNodes();
  if (currentTab === 'map')    renderMap();
}

// UI 配置
function renderConfig() {
  data.config.forEach((item, i) => {
    const wrapper = document.createElement('div');
    wrapper.className = 'mb-2';
    const label = document.createElement('label');
    label.textContent = item.name + ':';
    wrapper.appendChild(label);

    let input;
    if (item.type === 'number' || item.type === 'string') {
      input = document.createElement('input');
      input.type = item.type;
      input.value = item.value || '';
    }
    if (item.type === 'select') {
      input = document.createElement('select');
      item.option.forEach(opt => {
        const o = document.createElement('option');
        o.value = opt.value;
        o.textContent = opt.label;
        if (opt.value === item.value) o.selected = true;
        input.appendChild(o);
      });
    }
    input.onchange = e => (data.config[i].value = e.target.value);
    wrapper.appendChild(input);
    content.appendChild(wrapper);
  });
}

// Node-RED 节点
function renderNodes() {
  data.nodes.forEach(node => {
    const card = document.createElement('div');
    card.className = 'border p-2 mb-2 rounded';
    card.innerHTML = `<strong>${node.name || node.type}</strong><br/>ID: ${node.id}<br/>类型: ${node.type}`;
    content.appendChild(card);
  });
}

// 替换规则
function renderMap() {
  ['interface', 'protocol'].forEach(section => {
    data.map[section].forEach(m => {
      const card = document.createElement('div');
      card.className = 'border p-2 mb-2 rounded';
      card.innerHTML = `<strong>${section} - ${m.key}</strong><br/>节点ID: ${m.replace.id}<br/>属性: ${m.replace.name}`;
      content.appendChild(card);
    });
  });
}

// 切换 Tabs
tabs.forEach(btn => btn.onclick = () => {
  currentTab = btn.dataset.tab;
  tabs.forEach(b => b.classList.remove('font-bold'));
  btn.classList.add('font-bold');
  render();
});

// 导出 JSON
exportBtn.onclick = () => {
  const blob = new Blob([JSON.stringify(data, null, 2)], { type: 'application/json' });
  const url  = URL.createObjectURL(blob);
  const a    = document.createElement('a');
  a.href     = url;
  a.download = 'export.json';
  a.click();
  URL.revokeObjectURL(url);
};

// 初始渲染
tabs[0].classList.add('font-bold');
render();