

window.addEventListener('DOMContentLoaded', () => {
    const replaceText = (selector, text) => {
      const element = document.getElementById(selector)
      if (element) element.innerText = text
    }
  
    for (const dependency of ['chrome', 'node', 'electron']) {
      replaceText(`${dependency}-version`, process.versions[dependency])
    }
  })

//IPC
const { contextBridge, ipcRenderer } = require('electron')

window.myAPI = {
    setTitle: (title) => ipcRenderer.send('set-title', title)
}

//window.iotAPI = {
 //  doAction: (action, callback) => ipcRenderer.send('doAction', action, callback),
//   setToken:(token) =>  ipcRenderer.send('set-token', token),
//   getToken:() => ipcRenderer.invoke('get-token')
//}

contextBridge.exposeInMainWorld('iotAPI',  {
     getToken: () => ipcRenderer.invoke('get-token'),
     setToken:(token) =>  ipcRenderer.invoke('set-token', token)
})



//contextBridge.exposeInMainWorld('require', require);

// contextBridge.exposeInMainWorld('electronAPI', {
//   //暴露setTitle接口给UI
//   setTitle: (title) => ipcRenderer.send('set-title', title)
// })



// 向 Vue 环境暴露通信接口（挂载到 window 上）
contextBridge.exposeInMainWorld('electronAPI', {
  // 获取服务地址
  getServerUrl: () => ipcRenderer.invoke('get-server-url'),
  // 设置服务地址
  setServerUrl: (url) => ipcRenderer.invoke('set-server-url', url),
// 向渲染进程暴露获取端口API
  getSerialPorts: () => ipcRenderer.invoke('get-serial-ports')
});


