// @wry-smile/utils 1.1.2

"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  at: () => at,
  getTypeName: () => getTypeName,
  is: () => is,
  isArray: () => isArray,
  isBoolean: () => isBoolean,
  isDate: () => isDate,
  isDef: () => isDef,
  isElement: () => isElement,
  isEmpty: () => isEmpty,
  isFunction: () => isFunction,
  isMap: () => isMap,
  isNull: () => isNull,
  isNullOrUnDef: () => isNullOrUnDef,
  isNumber: () => isNumber,
  isObject: () => isObject,
  isPromise: () => isPromise,
  isRegExp: () => isRegExp,
  isString: () => isString,
  isUnDef: () => isUnDef,
  isUrl: () => isUrl,
  isWindow: () => isWindow,
  last: () => last,
  queuePool: () => queuePool,
  randomHexString: () => randomHexString,
  randomString: () => randomString
});

// src/array.ts
function at(array, index) {
  const len = array.length;
  if (!len)
    return void 0;
  if (index < 0)
    index += len;
  return array[index];
}
function last(array) {
  return at(array, -1);
}

// src/promise.ts
function queuePool(queueTask = [], limit = 6) {
  const length = queueTask.length;
  const result = Array.from({ length }).fill(false);
  let count = 0;
  return new Promise((resolve) => {
    while (count < limit)
      next();
    function next() {
      const current = count++;
      if (current >= length) {
        result.every(Boolean) && resolve(result);
        return;
      }
      const currentExcuteFn = queueTask[current];
      if (typeof currentExcuteFn !== "function") {
        result[current] = {};
        throw Error(`Task with index value ${current} in queue is not a Function !`);
      }
      Promise.resolve(currentExcuteFn()).then((res) => {
        result[current] = res;
        if (current < length)
          next();
      }).catch((error) => {
        result[current] = error;
        if (current < length)
          next();
      });
    }
  });
}

// src/is.ts
var toString = Object.prototype.toString;
function is(val, type) {
  return toString.call(val) === `[object ${type}]`;
}
function isDef(val) {
  return typeof val !== "undefined";
}
function isUnDef(val) {
  return typeof val === "undefined";
}
function isObject(val) {
  return val !== null && is(val, "Object");
}
function isEmpty(val) {
  if (isArray(val) || isString(val))
    return val.length === 0;
  if (val instanceof Map || val instanceof Set)
    return val.size === 0;
  if (isObject(val))
    return Object.keys(val).length === 0;
  return false;
}
function isDate(val) {
  return is(val, "Date");
}
function isNull(val) {
  return val === null;
}
function isNullOrUnDef(val) {
  return isUnDef(val) || isNull(val);
}
function isNumber(val) {
  return is(val, "Number");
}
function isPromise(val) {
  return is(val, "Promise") && isObject(val) && isFunction(val.then) && isFunction(val.catch);
}
function isString(val) {
  return is(val, "String");
}
function isFunction(val) {
  return typeof val === "function";
}
function isBoolean(val) {
  return is(val, "Boolean");
}
function isRegExp(val) {
  return is(val, "RegExp");
}
function isArray(val) {
  return val && Array.isArray(val);
}
function isWindow(val) {
  return typeof window !== "undefined" && is(val, "Window");
}
function isElement(val) {
  return isObject(val) && !!val.tagName;
}
function isMap(val) {
  return is(val, "Map");
}
function isUrl(path) {
  const reg = /^http(s)?:\/\/([\w-]+\.)+[\w-]+(\/[\w- ./?%&=]*)?/;
  return reg.test(path);
}
function getTypeName(val) {
  if (val === null)
    return "null";
  const type = toString.call(val).slice(8, -1).toLowerCase();
  return typeof val === "object" || typeof val === "function" ? type : typeof val;
}

// src/string.ts
var urlAlphabet = "xQDLEdCZyzBnY_vcMIe-XFAGm9lWs8hV7ujafUSb6iHPO5gNK43wpTrtRq2k1J0o";
function randomString(size = 16, dict = urlAlphabet) {
  let id = "";
  let i = size;
  const len = dict.length;
  while (i--)
    id += dict[Math.random() * len | 0];
  return id;
}
function randomHexString(size = 6) {
  const dict = "2B0AD471FCG5368E9";
  return randomString(size, dict);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  at,
  getTypeName,
  is,
  isArray,
  isBoolean,
  isDate,
  isDef,
  isElement,
  isEmpty,
  isFunction,
  isMap,
  isNull,
  isNullOrUnDef,
  isNumber,
  isObject,
  isPromise,
  isRegExp,
  isString,
  isUnDef,
  isUrl,
  isWindow,
  last,
  queuePool,
  randomHexString,
  randomString
});
