"use strict";Object.defineProperty(exports, "__esModule", {value: true});// src/nodes/interval-multiples-timer/runtime/index.ts
var nodeInit = (RED) => {
  function IntervalMultiplesTimerNodeConstructor(config) {
    RED.nodes.createNode(this, config);
    RED.nodes.createNode(this, config);
    const node = this;
    const interval = config.interval || 0;
    let timer;
    const timeHandler = function() {
      const msg = {};
      msg.topic = config.topic;
      msg.payload = config.payload || Date.now();
      node.send(msg);
      timer = setTimeout(timeHandler, interval - Date.now() % interval);
    };
    timer = setTimeout(timeHandler, interval - Date.now() % interval);
    node.on("close", function() {
      clearTimeout(timer);
    });
  }
  RED.nodes.registerType("interval-multiples-timer", IntervalMultiplesTimerNodeConstructor);
};
var runtime_default = nodeInit;


exports.default = runtime_default;
