"use strict";Object.defineProperty(exports, "__esModule", {value: true}); function _optionalChain(ops) { let lastAccessLHS = undefined; let value = ops[0]; let i = 1; while (i < ops.length) { const op = ops[i]; const fn = ops[i + 1]; i += 2; if ((op === 'optionalAccess' || op === 'optionalCall') && value == null) { return undefined; } if (op === 'access' || op === 'optionalAccess') { lastAccessLHS = value; value = fn(value); } else if (op === 'call' || op === 'optionalCall') { value = fn((...args) => value.call(lastAccessLHS, ...args)); lastAccessLHS = undefined; } } return value; }// src/nodes/ai-reasoning/runtime/index.ts
var _child_process = require('child_process');

// ../node_modules/.pnpm/@wry-smile+utils@1.1.2/node_modules/@wry-smile/utils/dist/index.mjs
function at(array, index) {
  const len = array.length;
  if (!len)
    return void 0;
  if (index < 0)
    index += len;
  return array[index];
}
function isUnDef(val) {
  return typeof val === "undefined";
}

// src/nodes/ai-reasoning/runtime/index.ts
var _buffer = require('buffer');
var _process = require('process');
var _fs = require('fs');
var nodeInit = (RED) => {
  const runTaskMode = 0 /* Exec */;
  const isWindows = process.platform === "win32";
  const systemProgram = "source /home/orangepi/miniconda3/bin/activate rknn && python /home/orangepi/yunteng_ai/dev_env/rknn_toolkit_lite2/examples/yolov5_inference/testNodeRed.py";
  const splitSuffix = "=";
  function AiReasoningNodeConstructor(config) {
    RED.nodes.createNode(this, config);
    const node = this;
    this.name = config.name;
    this.program = config.program;
    this.programPath = config.programPath;
    this.identificationSource = config.identificationSource;
    this.identificationSourcePath = config.identificationSourcePath;
    this.identifyObject = config.identifyObject;
    this.spawnOpt = {
      windowsHide: true
    };
    this.timeoutPeriod = config.timeoutPeriod || 60 * 5 * 1e3;
    this.execOpt = {
      encoding: "binary",
      maxBuffer: RED.settings.execMaxBufferSize || 1e7,
      shell: process.platform === "linux" && _fs.existsSync.call(void 0, "/bin/bash") ? "/bin/bash" : void 0
    };
    this.activeProcesses = {};
    const cleanup = (pid2) => {
      _optionalChain([this, 'access', _ => _.activeProcesses, 'access', _2 => _2[pid2], 'optionalAccess', _3 => _3.kill, 'call', _4 => _4()]);
    };
    function setNodeStatus(code) {
      if (code === 0)
        node.status({});
      if (code === null) {
        node.status({ fill: "red", shape: "dot", text: "killed" });
      } else if (code < 0) {
        node.status({ fill: "red", shape: "dot", text: `rc: ${code}` });
      } else {
        node.status({ fill: "yellow", shape: "dot", text: `rc: ${code}` });
      }
    }
    function checkProcessExist(pid2) {
      return Object.hasOwn(node.activeProcesses, pid2) && node.activeProcesses[pid2] !== null;
    }
    this.on("input", (msg, send, done) => {
      if (Object.hasOwn(msg, "kill")) {
        const kill = msg.kill;
        if (typeof kill === "string" || kill.length === 0 || !kill.toUpperCase().startWith("SIG")) {
          msg.kill = "SIGTERM";
        }
        if (Object.hasOwn(msg, "pid")) {
          const pid2 = msg.pid;
          if (Object.hasOwn(node.activeProcesses, pid2)) {
            _optionalChain([node, 'access', _5 => _5.activeProcesses, 'access', _6 => _6[pid2], 'optionalAccess', _7 => _7.kill, 'call', _8 => _8(msg.kill.toUpperCase())]);
            node.status({ fill: "red", shape: "dot", text: "killed" });
          }
        } else {
          if (Object.keys(node.activeProcesses).length === 1) {
            const pid2 = at(Object.keys(node.activeProcesses), 0);
            _optionalChain([node, 'access', _9 => _9.activeProcesses, 'access', _10 => _10[pid2], 'optionalAccess', _11 => _11.kill, 'call', _12 => _12(msg.kill.toUpperCase())]);
            node.status({ fill: "red", shape: "dot", text: "killed" });
          }
        }
        done();
      } else {
        let child;
        let command = node.program === "custom" /* Custom */ ? node.programPath : systemProgram;
        command += ` -${node.identificationSource === "Image" /* Image */ ? "Image" /* Image */ : "Rtsp" /* Rtsp */}${splitSuffix}${node.identificationSourcePath}`;
        command += ` -IdentifyObject${splitSuffix}${node.identifyObject}`;
        command = _optionalChain([command, 'optionalAccess', _13 => _13.trim, 'call', _14 => _14()]);
        let arg = _optionalChain([command, 'optionalAccess', _15 => _15.match, 'call', _16 => _16(/(?:[^\s"]+|"[^"]*")+/g), 'optionalAccess', _17 => _17.map, 'call', _18 => _18((a) => {
          if (/^".*"$/.test(a)) {
            return a.slice(1, -1);
          } else {
            return a;
          }
        })]);
        const cmd = _optionalChain([arg, 'optionalAccess', _19 => _19.shift, 'call', _20 => _20()]);
        const opts = isWindows ? { shell: true } : node.spawnOpt;
        node.debug(`${cmd} ["${arg}"]`);
	console.log(`${cmd} ["${arg}"]`);
        if (runTaskMode === 1 /* Spawn */) {
          child = _child_process.spawn.call(void 0, cmd, arg, opts);
          node.status({ fill: "blue", shape: "dot", text: `pid: ${child.pid}` });
          let unknownCommand = isUnDef(child.pid);
          if (this.timeoutPeriod) {
            child.timer = setTimeout(() => {
              cleanup(child.pid);
            }, node.timeoutPeriod);
          }
          if (child.pid) {
            node.activeProcesses[child.pid] = child;
          }
          _optionalChain([child, 'access', _21 => _21.stdout, 'optionalAccess', _22 => _22.on, 'call', _23 => _23("data", (data) => {
            if (checkProcessExist(child.pid)) {
              if (_buffer.isUtf8.call(void 0, data)) {
                msg.payload = data.toString();
              } else {
                msg.payload = data;
              }
              send([RED.util.cloneMessage(msg), null, null]);
            }
          })]);
          _optionalChain([child, 'access', _24 => _24.stderr, 'optionalAccess', _25 => _25.on, 'call', _26 => _26("data", (data) => {
            if (checkProcessExist(child.pid)) {
              if (_buffer.isUtf8.call(void 0, data)) {
                msg.payload = data.toString();
              } else {
                msg.payload = Buffer.from(data);
              }
              send([null, RED.util.cloneMessage(msg), null]);
            }
          })]);
          child.on("close", (code, signal) => {
            if (child.timer) {
              clearTimeout(child.timer);
            }
            if (unknownCommand || checkProcessExist(child.pid)) {
              delete node.activeProcesses[child.pid];
              setNodeStatus(code);
            }
            done();
          });
          child.on("error", (error) => {
            delete node.activeProcesses[child.pid];
            if (child.timer) {
              clearTimeout(child.timer);
            }
            if (checkProcessExist(_process.pid)) {
              node.error(error, RED.util.cloneMessage(msg));
            }
            send([null, RED.util.cloneMessage(msg), null]);
          });
        } else if (runTaskMode === 0 /* Exec */) {
          child = _child_process.exec.call(void 0, command, this.execOpt, function(error, stdout, stderr) {
            let rStderr = null, rError = null;
            delete msg.payload;
            if (stderr) {
              rStderr = RED.util.cloneMessage(msg);
              rStderr.payload = stderr;
            }
            msg.payload = Buffer.from(stdout, "binary");
            if (_buffer.isUtf8.call(void 0, msg.payload)) {
              msg.payload = msg.payload.toString();
            }
            node.status({});
            if (error !== null) {
              rError = RED.util.cloneMessage(msg);
              rError.payload = {
                code: error.code,
                message: error.message
              };
              if (error.signal) {
                ;
                rError.payload.signal = error.signal;
              }
              if (error.code === null) {
                node.status({ fill: "red", shape: "dot", text: "killed" });
              } else {
                node.status({ fill: "red", shape: "dot", text: "error:" + error.code });
              }
              node.debug("error:" + error);
            }
            if (!rError) {
              node.status({});
            } else {
              ;
              msg.rc = rError.payload;
              if (rStderr) {
                rStderr.rc = rError.payload;
              }
            }
            node.send([msg, rStderr, rError]);
            if (child.timer) {
              clearTimeout(child.timer);
            }
            delete node.activeProcesses[child.pid];
            done();
          });
          node.status({ fill: "blue", shape: "dot", text: "pid:" + child.pid });
          child.on("error", function() {
          });
          if (node.timeoutPeriod !== 0) {
            child.timer = setTimeout(function() {
              cleanup(child.pid);
            }, node.timeoutPeriod);
          }
          if (child.pid) {
            node.activeProcesses[child.pid] = child;
          }
        }
      }
    });
    this.on("close", () => {
      for (const pid2 in node.activeProcesses) {
        if (Object.hasOwn(node.activeProcesses, pid2)) {
          const process2 = node.activeProcesses[pid2];
          node.activeProcesses[pid2] = null;
          _optionalChain([process2, 'optionalAccess', _27 => _27.kill, 'call', _28 => _28()]);
        }
      }
    });
  }
  function AiReasoningConfigNodeConstructor(config) {
    RED.nodes.createNode(this, config);
    const node = this;
    this.name = "";
  }
  RED.nodes.registerType("ai-reasoning", AiReasoningNodeConstructor);
  RED.nodes.registerType("ai-reasoning-config", AiReasoningConfigNodeConstructor);
};
var runtime_default = nodeInit;


exports.default = runtime_default;
