const { app, BrowserWindow,Menu, ipcMain, dialog, protocol, session, globalShortcut} = require('electron')

let currentAction
let currentCallbak
let currentWin
let currentToken
let uiwindow
const path = require('path')
const { Writable } = require('stream');
const fs = require('fs').promises;
const record = require('node-record-lpcm16');
const { spawn, exec,execFile} = require('child_process');
const sudoPrompt = require('sudo-prompt');
const os = require('os');
const Store = require('electron-store');
const { setEngine } = require('crypto');
const { stdout, stderr } = require('process');
const configStore = new Store();
const psTree = require('ps-tree');



Menu.setApplicationMenu(null);
// 确保单实例运行
const gotTheLock = app.requestSingleInstanceLock();
if (!gotTheLock) {
  app.quit();
} else {
  app.on('second-instance', (event, commandLine, workingDirectory) => {
    if (uiwindow) {
      if (uiwindow.isMinimized()) uiwindow.restore();
      uiwindow.focus();
    }
  });
}
//主界面
const createWindow = () => {
    const win = new BrowserWindow({
      width: 1400,
      height: 900,
      title: '物联网测试验证平台',
      autoHideMenuBar: true,
     // icon: path.join(__dirname, 'white.png'),
      webPreferences: {
        webSecurity:false,
        webviewTag: true,
        nodeIntegrationInSubFrames:true,
        nodeIntegration:true,//允许页面中访问nodejs
        enableRemoteModule: true,
        contextIsolation: true,    //禁用上下文隔离
        preload: path.join(__dirname, 'preload.js'),
        session: {
          cache: false
        }
      }
    })
    uiwindow = win
    uiwindow.on('close', () => {
   
      uiwindow.destroy();
    });
    
    //win.webContents.on('did-fail-load', () => {
    //  console.log("load error")
      // 在页面加载失败时弹出配置页面
      //showConfigPage();
    //});
    //open debug
    win.webContents.openDevTools()
    var url = "http://192.168.0.73:8085"//loadSavedURLConfig()
    //if(token1!= "." && token1!= "" && typeof(token1)!="undefined"){
    //  url = url+"?"+"token="+token1
    //}
    console.log('url:',url)
    win.webContents.session.clearCache(() => {
      //win.loadURL(url);
    });
    // win.loadURL(url)
    win.loadFile(path.join(__dirname, 'web/index.html'));
  }

const userDataPath=app.getPath('userData')

// 配置文件路径（用户目录，无权限问题）
const configPath = path.join(userDataPath, 'serverConfig.json');
// 初始化配置文件
async function initConfigFile() {
  try {
    await fs.access(configPath);
  } catch {
    await fs.writeFile(configPath, JSON.stringify({ serverUrl: '' }, null, 2));
  }
}

// 读取服务地址
async function getServerUrl() {
  await initConfigFile()
  const content = await fs.readFile(configPath, 'utf8');
  return JSON.parse(content).serverUrl || '';
}

// 写入服务地址
async function setServerUrl(url) {
  await initConfigFile()
  const content = await fs.readFile(configPath, 'utf8');
  const config = JSON.parse(content);
  config.serverUrl = url;
  await fs.writeFile(configPath, JSON.stringify(config, null, 2));
}

  //IPC设置标题
function handleSetTitle (event, title) {
    const webContents = event.sender
    const win = BrowserWindow.fromWebContents(webContents)
    win.setTitle(title)
    win.webContents.executeJavaScript('result("调用成功")')
  }

 
//统一事件处理 doAction
function handleAction(event, action, callback) {
  const webContents = event.sender
  const win = BrowserWindow.fromWebContents(webContents)
  currentWin = win
  console.log(action)
  const json = JSON.parse(action)
  console.log('TAG:handleAction ','action=',json.action,';callback=',callback,';tagType:',json.tagType)
  tagType = json.tagType
  currentAction = json.action
  currentCallbak = callback
  switch(json.action){
    case 'OPEN_OCR':
      //createTakePhotoOCR()
      break;
  }
}

function setToken(event, token){
  console.log("setToken:",token);
  currentToken = token;
}

function getToken(){
  console.log("getToken:",currentToken);
  return currentToken;
}

const runServe=()=>{
  //启动node-red
//指定运行目录的绝对路径（示例为Electron应用内的子目录）
const targetDir = path.join(__dirname, 'nr');

const nodeRedProcess = spawn('node', ['main.js', '-c=config.js'], {
  cwd: targetDir, // 关键参数
  stdio: 'inherit' // 可选：继承父进程的输入输出
});
// startNodeRed()
//启动mqtt服务
const mqttTargetDir = path.join(__dirname, 'mqtt');

const mqttNodeRedProcess = spawn('node', ['mqtt.js'], {
  cwd: mqttTargetDir, // 关键参数
  stdio: 'inherit' // 可选：继承父进程的输入输出
});
}

app.whenReady().then(async () => {

  

  // 定义自定义路径（示例：应用根目录下的 'user_data' 文件夹）
  const customUserDataPath = path.join(app.getAppPath(), 'user_data');
  await initConfigFile();
  // 响应渲染进程的"获取服务地址"请求
  ipcMain.handle('get-server-url', getServerUrl);
  // 响应渲染进程的"设置服务地址"请求
  ipcMain.handle('set-server-url', (_, url) => setServerUrl(url));
  // 设置用户数据目录
  app.setPath('userData', customUserDataPath);
  

    //注册设置标题函数
    ipcMain.on('set-title', handleSetTitle)
    //注册action 
    ipcMain.on('doAction', handleAction)

    //token
    ipcMain.handle('set-token',setToken);
    ipcMain.handle('get-token',getToken);

    //注册atom自定义协议，用于h5页面访问本地文件
    protocol.registerFileProtocol('atom', (request, callback) => {
      const url = request.url.substr(7)
      const dURL = decodeURI(path.normalize(url))
      console.log("dURL:",dURL)
      callback(dURL)
    })
    global.sharedObject = { 
      argv: process.argv
    }

    console.log("sharedObject:",global.sharedObject.argv[0],";",global.sharedObject.argv[1],";",global.sharedObject.argv[2])
    token1 = global.sharedObject.argv[1]
    token2 = global.sharedObject.argv[2]
    console.log("token1:",token1,",token2:",token2,";")
    createWindow()
    runServe()

  })



/**
 * 清除占用指定端口的进程
 * @param {number} port - 端口号（如 10883）
 * @returns {Promise<void>}
 */
function clearPortProcess(port) {
  return new Promise((resolve, reject) => {
    // 根据系统选择命令（Linux/macOS 使用 lsof，Windows 使用 netstat）
    let command;
    if (process.platform === 'win32') {
      // Windows：查找端口对应的PID并终止
      command = `netstat -ano | findstr :${port} | findstr LISTENING | for /f "tokens=5" %a in ('more') do taskkill /F /PID %a`;
    } else {
      // Linux/macOS：查找端口对应的PID并终止
      command = `lsof -t -i :${port} | xargs -r kill -9`;
    }

    exec(command, (error, stdout, stderr) => {
      if (error) {
        // 忽略"未找到进程"的错误（非致命）
        if (stderr.includes('找不到') || stdout.trim() === '') {
          console.log(`端口 ${port} 未被占用，无需清理`);
          return resolve();
        }
        return reject(new Error(`清理端口失败: ${stderr}`));
      }
      console.log(`已成功终止占用端口 ${port} 的进程`);
      resolve();
    });
  });
}


app.on('before-quit', async (event) => {
  event.preventDefault(); // 阻止默认退出，等待清理完成
  try {
    console.log('开始清理 10883 端口...');
    await clearPortProcess(10883); // 执行清理逻辑
    console.log('清理完成，退出应用');
    app.exit(0); // 强制退出（0 表示正常退出）
  } catch (err) {
    console.error('清理失败，强制退出:', err);
    app.exit(1); // 异常退出（非0状态码）
  }
});
