/**
 * Copyright JS Foundation and other contributors, http://js.foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **/
(function($) {

/**
 * options:
 *   - invertState   : boolean - if "true" the button will show "enabled" when the
 *                             checkbox is not selected and vice versa.
 *   - enabledIcon   : string - the icon for "enabled" state, default "fa-check-square-o"
 *   - enabledLabel  : string - the label for "enabled" state, default "Enabled" ("editor:workspace.enabled")
 *   - disabledIcon  : string - the icon for "disabled" state, default "fa-square-o"
 *   - disabledLabel : string - the label for "disabled" state, default "Disabled" ("editor:workspace.disabled")
 *   - baseClass     : string - the base css class to apply, default "red-ui-button" (alternative eg "red-ui-sidebar-header-button")
 *   - class         : string - additional classes to apply to the button - eg "red-ui-button-small"
 * methods:
 *   -
 */
    $.widget( "nodered.toggleButton", {
        _create: function() {
            var that = this;

            var invertState = false;
            if (this.options.hasOwnProperty("invertState")) {
                invertState = this.options.invertState;
            }
            var baseClass = this.options.baseClass || "red-ui-button";
            var enabledIcon = this.options.hasOwnProperty('enabledIcon')?this.options.enabledIcon : "fa-check-square-o";
            var disabledIcon = this.options.hasOwnProperty('disabledIcon')?this.options.disabledIcon : "fa-square-o";
            var enabledLabel = this.options.hasOwnProperty('enabledLabel') ? this.options.enabledLabel : RED._("editor:workspace.enabled");
            var disabledLabel = this.options.hasOwnProperty('disabledLabel') ? this.options.disabledLabel : RED._("editor:workspace.disabled");

            this.element.css("display","none");
            this.element.on("focus", function() {
                that.button.focus();
            });
            this.button = $('<button type="button" class="red-ui-toggleButton '+baseClass+' toggle single"></button>');
            if (enabledLabel || disabledLabel) {
                this.buttonLabel = $("<span>").appendTo(this.button).css("margin-left", "5px");
            }

            if (this.options.class) {
                this.button.addClass(this.options.class)
            }
            this.element.after(this.button);

            if (enabledIcon && disabledIcon) {
                this.buttonIcon = $('<i class="fa"></i>').prependTo(this.button);
            }

            // Quick hack to find the maximum width of the button
            this.button.addClass("selected");
            if (this.buttonIcon) {
                this.buttonIcon.addClass(enabledIcon);
            }
            if (this.buttonLabel) {
                this.buttonLabel.text(enabledLabel);
            }
            var width = this.button.width();
            this.button.removeClass("selected");
            if (this.buttonIcon) {
                this.buttonIcon.removeClass(enabledIcon);
                that.buttonIcon.addClass(disabledIcon);
            }
            if (this.buttonLabel) {
                that.buttonLabel.text(disabledLabel);
            }
            width = Math.max(width,this.button.width());
            if (this.buttonIcon) {
                this.buttonIcon.removeClass(disabledIcon);
            }

            // Fix the width of the button so it doesn't jump around when toggled
            if (width > 0) {
                this.button.width(Math.ceil(width));
            }

            this.button.on("click",function(e) {
                e.stopPropagation();
                if (!that.state) {
                    that.element.prop("checked",!invertState);
                } else {
                    that.element.prop("checked",invertState);
                }
                that.element.trigger("change");
            })

            this.element.on("change", function(e) {
                if ($(this).prop("checked") !== invertState) {
                    that.button.addClass("selected");
                    that.state = true;
                    if (that.buttonIcon) {
                        that.buttonIcon.addClass(enabledIcon);
                        that.buttonIcon.removeClass(disabledIcon);
                    }
                    if (that.buttonLabel) {
                        that.buttonLabel.text(enabledLabel);
                    }
                } else {
                    that.button.removeClass("selected");
                    that.state = false;
                    if (that.buttonIcon) {
                        that.buttonIcon.addClass(disabledIcon);
                        that.buttonIcon.removeClass(enabledIcon);
                    }
                    if (that.buttonLabel) {
                        that.buttonLabel.text(disabledLabel);
                    }
                }
            })
            this.element.trigger("change");
        }
    });
})(jQuery);
