function createStorage({
                           prefixKey = "",
                           storage = sessionStorage,
                           timeout = null,
                           setMiddleware = [],
                           getMiddleware = []
                       } = {}) {
    const WebStorage = class WebStorage {
        /**
         *
         * @param {*} storage
         */
        constructor() {
            this.storage = storage
            this.prefixKey = prefixKey
        }

        getKey(key) {
            return `${this.prefixKey}${key}`.toUpperCase()
        }

        set(key, value, expire = timeout) {
            const stringData = JSON.stringify({
                value,
                time: Date.now(),
                expire: !isNullOrUnDef(expire) ? Date.now() + expire * 1000 : null
            })

            const stringifyValue = setMiddleware.reduce((prev, next) => {
                return next(prev)
            }, stringData)

            this.storage.setItem(this.getKey(key), stringifyValue)
        }

        get(key, def = null) {
            const val = this.storage.getItem(this.getKey(key))
            if (!val) return def

            try {
                const decVal = getMiddleware.reduce((prev, next) => {
                    return next(prev)
                }, val)

                const data = JSON.parse(decVal)
                const {value, expire} = data
                if (isNullOrUnDef(expire) || expire >= new Date().getTime())
                    return value

                this.remove(key)
            } catch (e) {
                return def
            }
        }

        remove(key) {
            this.storage.removeItem(this.getKey(key))
        }

        clear() {
            this.storage.clear()
        }
    }
    return new WebStorage()
}
