function getStorageShortName() {
    return `__APP__`
}

function createOptions(storage, options = {}) {
    return {
        storage,
        prefixKey: getStorageShortName(),
        ...options
    }
}

const WebStorage = createStorage(createOptions(sessionStorage))

function createWebStorage(storage = sessionStorage, options = {}) {
    return createStorage(createOptions(storage, options))
}

function createSessionStorage(options = {}) {
    return createWebStorage(sessionStorage, {
        ...options,
        timeout: DEFAULT_CACHE_TIME
    })
}

function createLocalStorage(options = {}) {
    return createWebStorage(localStorage, {
        ...options,
        timeout: DEFAULT_CACHE_TIME
    })
}


function getAuthCache(key) {
    const fn = isLocal ? Persistent.getLocal : Persistent.getSession
    return fn(key)
}

function setAuthCache(key, value) {
    const fn = isLocal ? Persistent.setLocal : Persistent.setLocal
    return fn(key, value, true)
}

function clearAuthCache(immediate = true) {
    const fn = isLocal ? Persistent.clearLocal : Persistent.clearSession
    return fn(immediate)
}

function getJWTToken() {
    return getAuthCache(JWT_TOKEN_KEY)
}

function getRefreshToken() {
    return getAuthCache(REFRESH_TOKEN_KEY)
}
