/**
 * Copyright JS Foundation and other contributors, http://js.foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **/
RED.validators = {
    number: function(blankAllowed,mopt){
        return function(v, opt) {
            if (blankAllowed && (v === '' || v === undefined)) {
                return true
            }
            if (v !== '') {
                if (/^NaN$|^[+-]?[0-9]*\.?[0-9]*([eE][-+]?[0-9]+)?$|^[+-]?(0b|0B)[01]+$|^[+-]?(0o|0O)[0-7]+$|^[+-]?(0x|0X)[0-9a-fA-F]+$/.test(v)) {
                    return true
                }
                if (/^\${[^}]+}$/.test(v)) {
                    // Allow ${ENV_VAR} value
                    return true
                }
            }
            if (!isNaN(v)) {
                return true
            }
            if (opt && opt.label) {
                return RED._("validator.errors.invalid-num-prop", {
                    prop: opt.label
                });
            }
            return opt ? RED._("validator.errors.invalid-num") : false;
        };
    },
    regex: function(re, mopt) {
        return function(v, opt) {
            if (re.test(v)) {
                return true;
            }
            if (opt && opt.label) {
                return RED._("validator.errors.invalid-regex-prop", {
                    prop: opt.label
                });
            }
            return opt ? RED._("validator.errors.invalid-regexp") : false;
        };
    },
    typedInput: function(ptypeName, isConfig, mopt) {
        let options = ptypeName
        if (typeof ptypeName === 'string' ) {
            options = {}
            options.typeField = ptypeName
            options.isConfig = isConfig
            options.allowBlank = false
        }
        return function(v, opt) {
            let ptype = options.type
            if (!ptype && options.typeField) {
                ptype = $("#node-"+(options.isConfig?"config-":"")+"input-"+options.typeField).val() || this[options.typeField];
            }
            if (options.allowBlank && v === '') {
                return true
            }
            if (options.allowUndefined && v === undefined) {
                return true
            }
            const result = RED.utils.validateTypedProperty(v, ptype, opt)
            if (result === true || opt) {
                // Valid, or opt provided - return result as-is
                return result
            }
            // No opt - need to return false for backwards compatibilty
            return false
        }
    }
};