/**
 * Copyright JS Foundation and other contributors, http://js.foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **/


RED.panels = (function() {

    function createPanel(options) {
        var container = options.container || $("#"+options.id);
        var children = container.children();
        if (children.length !== 2) {
            console.log(options.id);
            throw new Error("Container must have exactly two children");
        }
        var vertical = (!options.dir || options.dir === "vertical");
        container.addClass("red-ui-panels");
        if (!vertical) {
            container.addClass("red-ui-panels-horizontal");
        }

        $(children[0]).addClass("red-ui-panel");
        $(children[1]).addClass("red-ui-panel");

        var separator = $('<div class="red-ui-panels-separator"></div>').insertAfter(children[0]);
        var startPosition;
        var panelSizes = [];
        var modifiedSizes = false;
        var panelRatio = 0.5;
        separator.draggable({
                axis: vertical?"y":"x",
                containment: container,
                scroll: false,
                start:function(event,ui) {
                    startPosition = vertical?ui.position.top:ui.position.left;

                    panelSizes = [
                        vertical?$(children[0]).height():$(children[0]).width(),
                        vertical?$(children[1]).height():$(children[1]).width()
                    ];
                },
                drag: function(event,ui) {
                    var size = vertical?container.height():container.width();
                    var delta = (vertical?ui.position.top:ui.position.left)-startPosition;
                    var newSizes = [panelSizes[0]+delta,panelSizes[1]-delta];
                    if (vertical) {
                        $(children[0]).height(newSizes[0]);
                        // $(children[1]).height(newSizes[1]);
                        ui.position.top -= delta;
                    } else {
                        $(children[0]).width(newSizes[0]);
                        // $(children[1]).width(newSizes[1]);
                        ui.position.left -= delta;
                    }
                    if (options.resize) {
                        options.resize(newSizes[0],newSizes[1]);
                    }
                    panelRatio = newSizes[0]/(size-8);
                },
                stop:function(event,ui) {
                    modifiedSizes = true;
                }
        });

        var panel = {
            ratio: function(ratio) {
                if (ratio === undefined) {
                    return panelRatio;
                }
                panelRatio = ratio;
                modifiedSizes = true;
                if (ratio === 0 || ratio === 1) {
                    separator.hide();
                } else {
                    separator.show();
                }
                if (vertical) {
                    panel.resize(container.height());
                } else {
                    panel.resize(container.width());
                }
            },
            resize: function(size) {
                var panelSizes;
                if (vertical) {
                    panelSizes = [$(children[0]).outerHeight(),$(children[1]).outerHeight()];
                    container.height(size);
                } else {
                    panelSizes = [$(children[0]).outerWidth(),$(children[1]).outerWidth()];
                    container.width(size);
                }
                if (modifiedSizes) {
                    var topPanelSize = panelRatio*(size-8);
                    var bottomPanelSize = size - topPanelSize - 8;
                    panelSizes = [topPanelSize,bottomPanelSize];
                    if (vertical) {
                        $(children[0]).outerHeight(panelSizes[0]);
                        // $(children[1]).outerHeight(panelSizes[1]);
                    } else {
                        $(children[0]).outerWidth(panelSizes[0]);
                        // $(children[1]).outerWidth(panelSizes[1]);
                    }
                }
                if (options.resize) {
                    if (vertical) {
                        panelSizes = [$(children[0]).height(),$(children[1]).height()];
                    } else {
                        panelSizes = [$(children[0]).width(),$(children[1]).width()];
                    }
                    options.resize(panelSizes[0],panelSizes[1]);
                }
            }
        }
        return panel;
    }

    return {
        create: createPanel
    }
})();
