/**
 * Copyright JS Foundation and other contributors, http://js.foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **/

RED.nodes.fontAwesome = (function() {

    var iconMap = {
        "fa-address-book-o": "\uf2ba",
        "fa-address-book": "\uf2b9",
        "fa-address-card-o": "\uf2bc",
        "fa-address-card": "\uf2bb",
        "fa-adjust": "\uf042",
        "fa-align-center": "\uf037",
        "fa-align-justify": "\uf039",
        "fa-align-left": "\uf036",
        "fa-align-right": "\uf038",
        "fa-ambulance": "\uf0f9",
        "fa-american-sign-language-interpreting": "\uf2a3",
        "fa-anchor": "\uf13d",
        "fa-angle-double-down": "\uf103",
        "fa-angle-double-left": "\uf100",
        "fa-angle-double-right": "\uf101",
        "fa-angle-double-up": "\uf102",
        "fa-angle-down": "\uf107",
        "fa-angle-left": "\uf104",
        "fa-angle-right": "\uf105",
        "fa-angle-up": "\uf106",
        "fa-archive": "\uf187",
        "fa-area-chart": "\uf1fe",
        "fa-arrow-circle-down": "\uf0ab",
        "fa-arrow-circle-left": "\uf0a8",
        "fa-arrow-circle-o-down": "\uf01a",
        "fa-arrow-circle-o-left": "\uf190",
        "fa-arrow-circle-o-right": "\uf18e",
        "fa-arrow-circle-o-up": "\uf01b",
        "fa-arrow-circle-right": "\uf0a9",
        "fa-arrow-circle-up": "\uf0aa",
        "fa-arrow-down": "\uf063",
        "fa-arrow-left": "\uf060",
        "fa-arrow-right": "\uf061",
        "fa-arrow-up": "\uf062",
        "fa-arrows-alt": "\uf0b2",
        "fa-arrows-h": "\uf07e",
        "fa-arrows-v": "\uf07d",
        "fa-arrows": "\uf047",
        "fa-asl-interpreting": "\uf2a3",
        "fa-assistive-listening-systems": "\uf2a2",
        "fa-asterisk": "\uf069",
        "fa-at": "\uf1fa",
        "fa-audio-description": "\uf29e",
        "fa-automobile": "\uf1b9",
        "fa-backward": "\uf04a",
        "fa-balance-scale": "\uf24e",
        "fa-ban": "\uf05e",
        "fa-bank": "\uf19c",
        "fa-bar-chart-o": "\uf080",
        "fa-bar-chart": "\uf080",
        "fa-barcode": "\uf02a",
        "fa-bars": "\uf0c9",
        "fa-bath": "\uf2cd",
        "fa-bathtub": "\uf2cd",
        "fa-battery-0": "\uf244",
        "fa-battery-1": "\uf243",
        "fa-battery-2": "\uf242",
        "fa-battery-3": "\uf241",
        "fa-battery-4": "\uf240",
        "fa-battery-empty": "\uf244",
        "fa-battery-full": "\uf240",
        "fa-battery-half": "\uf242",
        "fa-battery-quarter": "\uf243",
        "fa-battery-three-quarters": "\uf241",
        "fa-battery": "\uf240",
        "fa-bed": "\uf236",
        "fa-beer": "\uf0fc",
        "fa-bell-o": "\uf0a2",
        "fa-bell-slash-o": "\uf1f7",
        "fa-bell-slash": "\uf1f6",
        "fa-bell": "\uf0f3",
        "fa-bicycle": "\uf206",
        "fa-binoculars": "\uf1e5",
        "fa-birthday-cake": "\uf1fd",
        "fa-blind": "\uf29d",
        "fa-bold": "\uf032",
        "fa-bolt": "\uf0e7",
        "fa-bomb": "\uf1e2",
        "fa-book": "\uf02d",
        "fa-bookmark-o": "\uf097",
        "fa-bookmark": "\uf02e",
        "fa-braille": "\uf2a1",
        "fa-briefcase": "\uf0b1",
        "fa-bug": "\uf188",
        "fa-building-o": "\uf0f7",
        "fa-building": "\uf1ad",
        "fa-bullhorn": "\uf0a1",
        "fa-bullseye": "\uf140",
        "fa-bus": "\uf207",
        "fa-cab": "\uf1ba",
        "fa-calculator": "\uf1ec",
        "fa-calendar-check-o": "\uf274",
        "fa-calendar-minus-o": "\uf272",
        "fa-calendar-o": "\uf133",
        "fa-calendar-plus-o": "\uf271",
        "fa-calendar-times-o": "\uf273",
        "fa-calendar": "\uf073",
        "fa-camera-retro": "\uf083",
        "fa-camera": "\uf030",
        "fa-car": "\uf1b9",
        "fa-caret-down": "\uf0d7",
        "fa-caret-left": "\uf0d9",
        "fa-caret-right": "\uf0da",
        "fa-caret-square-o-down": "\uf150",
        "fa-caret-square-o-left": "\uf191",
        "fa-caret-square-o-right": "\uf152",
        "fa-caret-square-o-up": "\uf151",
        "fa-caret-up": "\uf0d8",
        "fa-cart-arrow-down": "\uf218",
        "fa-cart-plus": "\uf217",
        "fa-cc": "\uf20a",
        "fa-certificate": "\uf0a3",
        "fa-chain-broken": "\uf127",
        "fa-chain": "\uf0c1",
        "fa-check-circle-o": "\uf05d",
        "fa-check-circle": "\uf058",
        "fa-check-square-o": "\uf046",
        "fa-check-square": "\uf14a",
        "fa-check": "\uf00c",
        "fa-chevron-circle-down": "\uf13a",
        "fa-chevron-circle-left": "\uf137",
        "fa-chevron-circle-right": "\uf138",
        "fa-chevron-circle-up": "\uf139",
        "fa-chevron-down": "\uf078",
        "fa-chevron-left": "\uf053",
        "fa-chevron-right": "\uf054",
        "fa-chevron-up": "\uf077",
        "fa-child": "\uf1ae",
        "fa-circle-o-notch": "\uf1ce",
        "fa-circle-o": "\uf10c",
        "fa-circle-thin": "\uf1db",
        "fa-circle": "\uf111",
        "fa-clipboard": "\uf0ea",
        "fa-clock-o": "\uf017",
        "fa-clone": "\uf24d",
        "fa-close": "\uf00d",
        "fa-cloud-download": "\uf0ed",
        "fa-cloud-upload": "\uf0ee",
        "fa-cloud": "\uf0c2",
        "fa-cny": "\uf157",
        "fa-code-fork": "\uf126",
        "fa-code": "\uf121",
        "fa-coffee": "\uf0f4",
        "fa-cog": "\uf013",
        "fa-cogs": "\uf085",
        "fa-columns": "\uf0db",
        "fa-comment-o": "\uf0e5",
        "fa-comment": "\uf075",
        "fa-commenting-o": "\uf27b",
        "fa-commenting": "\uf27a",
        "fa-comments-o": "\uf0e6",
        "fa-comments": "\uf086",
        "fa-compass": "\uf14e",
        "fa-compress": "\uf066",
        "fa-copy": "\uf0c5",
        "fa-copyright": "\uf1f9",
        "fa-creative-commons": "\uf25e",
        "fa-credit-card-alt": "\uf283",
        "fa-credit-card": "\uf09d",
        "fa-crop": "\uf125",
        "fa-crosshairs": "\uf05b",
        "fa-cube": "\uf1b2",
        "fa-cubes": "\uf1b3",
        "fa-cut": "\uf0c4",
        "fa-cutlery": "\uf0f5",
        "fa-dashboard": "\uf0e4",
        "fa-database": "\uf1c0",
        "fa-deaf": "\uf2a4",
        "fa-deafness": "\uf2a4",
        "fa-dedent": "\uf03b",
        "fa-desktop": "\uf108",
        "fa-diamond": "\uf219",
        "fa-dollar": "\uf155",
        "fa-dot-circle-o": "\uf192",
        "fa-download": "\uf019",
        "fa-drivers-license-o": "\uf2c3",
        "fa-drivers-license": "\uf2c2",
        "fa-edit": "\uf044",
        "fa-eject": "\uf052",
        "fa-ellipsis-h": "\uf141",
        "fa-ellipsis-v": "\uf142",
        "fa-envelope-o": "\uf003",
        "fa-envelope-open-o": "\uf2b7",
        "fa-envelope-open": "\uf2b6",
        "fa-envelope-square": "\uf199",
        "fa-envelope": "\uf0e0",
        "fa-eraser": "\uf12d",
        "fa-eur": "\uf153",
        "fa-euro": "\uf153",
        "fa-exchange": "\uf0ec",
        "fa-exclamation-circle": "\uf06a",
        "fa-exclamation-triangle": "\uf071",
        "fa-exclamation": "\uf12a",
        "fa-expand": "\uf065",
        "fa-external-link-square": "\uf14c",
        "fa-external-link": "\uf08e",
        "fa-eye-slash": "\uf070",
        "fa-eye": "\uf06e",
        "fa-eyedropper": "\uf1fb",
        "fa-fast-backward": "\uf049",
        "fa-fast-forward": "\uf050",
        "fa-fax": "\uf1ac",
        "fa-feed": "\uf09e",
        "fa-female": "\uf182",
        "fa-fighter-jet": "\uf0fb",
        "fa-file-archive-o": "\uf1c6",
        "fa-file-audio-o": "\uf1c7",
        "fa-file-code-o": "\uf1c9",
        "fa-file-excel-o": "\uf1c3",
        "fa-file-image-o": "\uf1c5",
        "fa-file-movie-o": "\uf1c8",
        "fa-file-o": "\uf016",
        "fa-file-pdf-o": "\uf1c1",
        "fa-file-photo-o": "\uf1c5",
        "fa-file-picture-o": "\uf1c5",
        "fa-file-powerpoint-o": "\uf1c4",
        "fa-file-sound-o": "\uf1c7",
        "fa-file-text-o": "\uf0f6",
        "fa-file-text": "\uf15c",
        "fa-file-video-o": "\uf1c8",
        "fa-file-word-o": "\uf1c2",
        "fa-file-zip-o": "\uf1c6",
        "fa-file": "\uf15b",
        "fa-files-o": "\uf0c5",
        "fa-film": "\uf008",
        "fa-filter": "\uf0b0",
        "fa-fire-extinguisher": "\uf134",
        "fa-fire": "\uf06d",
        "fa-flag-checkered": "\uf11e",
        "fa-flag-o": "\uf11d",
        "fa-flag": "\uf024",
        "fa-flash": "\uf0e7",
        "fa-flask": "\uf0c3",
        "fa-floppy-o": "\uf0c7",
        "fa-folder-o": "\uf114",
        "fa-folder-open-o": "\uf115",
        "fa-folder-open": "\uf07c",
        "fa-folder": "\uf07b",
        "fa-font": "\uf031",
        "fa-forward": "\uf04e",
        "fa-frown-o": "\uf119",
        "fa-futbol-o": "\uf1e3",
        "fa-gamepad": "\uf11b",
        "fa-gavel": "\uf0e3",
        "fa-gbp": "\uf154",
        "fa-gear": "\uf013",
        "fa-gears": "\uf085",
        "fa-genderless": "\uf22d",
        "fa-gift": "\uf06b",
        "fa-glass": "\uf000",
        "fa-globe": "\uf0ac",
        "fa-graduation-cap": "\uf19d",
        "fa-group": "\uf0c0",
        "fa-h-square": "\uf0fd",
        "fa-hand-grab-o": "\uf255",
        "fa-hand-lizard-o": "\uf258",
        "fa-hand-o-down": "\uf0a7",
        "fa-hand-o-left": "\uf0a5",
        "fa-hand-o-right": "\uf0a4",
        "fa-hand-o-up": "\uf0a6",
        "fa-hand-paper-o": "\uf256",
        "fa-hand-peace-o": "\uf25b",
        "fa-hand-pointer-o": "\uf25a",
        "fa-hand-rock-o": "\uf255",
        "fa-hand-scissors-o": "\uf257",
        "fa-hand-spock-o": "\uf259",
        "fa-hand-stop-o": "\uf256",
        "fa-handshake-o": "\uf2b5",
        "fa-hard-of-hearing": "\uf2a4",
        "fa-hashtag": "\uf292",
        "fa-hdd-o": "\uf0a0",
        "fa-header": "\uf1dc",
        "fa-headphones": "\uf025",
        "fa-heart-o": "\uf08a",
        "fa-heart": "\uf004",
        "fa-heartbeat": "\uf21e",
        "fa-history": "\uf1da",
        "fa-home": "\uf015",
        "fa-hospital-o": "\uf0f8",
        "fa-hotel": "\uf236",
        "fa-hourglass-1": "\uf251",
        "fa-hourglass-2": "\uf252",
        "fa-hourglass-3": "\uf253",
        "fa-hourglass-end": "\uf253",
        "fa-hourglass-half": "\uf252",
        "fa-hourglass-o": "\uf250",
        "fa-hourglass-start": "\uf251",
        "fa-hourglass": "\uf254",
        "fa-i-cursor": "\uf246",
        "fa-id-badge": "\uf2c1",
        "fa-id-card-o": "\uf2c3",
        "fa-id-card": "\uf2c2",
        "fa-ils": "\uf20b",
        "fa-image": "\uf03e",
        "fa-inbox": "\uf01c",
        "fa-indent": "\uf03c",
        "fa-industry": "\uf275",
        "fa-info-circle": "\uf05a",
        "fa-info": "\uf129",
        "fa-inr": "\uf156",
        "fa-institution": "\uf19c",
        "fa-intersex": "\uf224",
        "fa-italic": "\uf033",
        "fa-jpy": "\uf157",
        "fa-key": "\uf084",
        "fa-keyboard-o": "\uf11c",
        "fa-krw": "\uf159",
        "fa-language": "\uf1ab",
        "fa-laptop": "\uf109",
        "fa-leaf": "\uf06c",
        "fa-legal": "\uf0e3",
        "fa-lemon-o": "\uf094",
        "fa-level-down": "\uf149",
        "fa-level-up": "\uf148",
        "fa-life-bouy": "\uf1cd",
        "fa-life-buoy": "\uf1cd",
        "fa-life-ring": "\uf1cd",
        "fa-life-saver": "\uf1cd",
        "fa-lightbulb-o": "\uf0eb",
        "fa-line-chart": "\uf201",
        "fa-link": "\uf0c1",
        "fa-list-alt": "\uf022",
        "fa-list-ol": "\uf0cb",
        "fa-list-ul": "\uf0ca",
        "fa-list": "\uf03a",
        "fa-location-arrow": "\uf124",
        "fa-lock": "\uf023",
        "fa-long-arrow-down": "\uf175",
        "fa-long-arrow-left": "\uf177",
        "fa-long-arrow-right": "\uf178",
        "fa-long-arrow-up": "\uf176",
        "fa-low-vision": "\uf2a8",
        "fa-magic": "\uf0d0",
        "fa-magnet": "\uf076",
        "fa-mail-forward": "\uf064",
        "fa-mail-reply-all": "\uf122",
        "fa-mail-reply": "\uf112",
        "fa-male": "\uf183",
        "fa-map-marker": "\uf041",
        "fa-map-o": "\uf278",
        "fa-map-pin": "\uf276",
        "fa-map-signs": "\uf277",
        "fa-map": "\uf279",
        "fa-mars-double": "\uf227",
        "fa-mars-stroke-h": "\uf22b",
        "fa-mars-stroke-v": "\uf22a",
        "fa-mars-stroke": "\uf229",
        "fa-mars": "\uf222",
        "fa-medkit": "\uf0fa",
        "fa-meh-o": "\uf11a",
        "fa-mercury": "\uf223",
        "fa-microchip": "\uf2db",
        "fa-microphone-slash": "\uf131",
        "fa-microphone": "\uf130",
        "fa-minus-circle": "\uf056",
        "fa-minus-square-o": "\uf147",
        "fa-minus-square": "\uf146",
        "fa-minus": "\uf068",
        "fa-mobile-phone": "\uf10b",
        "fa-mobile": "\uf10b",
        "fa-money": "\uf0d6",
        "fa-moon-o": "\uf186",
        "fa-mortar-board": "\uf19d",
        "fa-motorcycle": "\uf21c",
        "fa-mouse-pointer": "\uf245",
        "fa-music": "\uf001",
        "fa-navicon": "\uf0c9",
        "fa-neuter": "\uf22c",
        "fa-newspaper-o": "\uf1ea",
        "fa-object-group": "\uf247",
        "fa-object-ungroup": "\uf248",
        "fa-outdent": "\uf03b",
        "fa-paint-brush": "\uf1fc",
        "fa-paper-plane-o": "\uf1d9",
        "fa-paper-plane": "\uf1d8",
        "fa-paperclip": "\uf0c6",
        "fa-paragraph": "\uf1dd",
        "fa-paste": "\uf0ea",
        "fa-pause-circle-o": "\uf28c",
        "fa-pause-circle": "\uf28b",
        "fa-pause": "\uf04c",
        "fa-paw": "\uf1b0",
        "fa-pencil-square-o": "\uf044",
        "fa-pencil-square": "\uf14b",
        "fa-pencil": "\uf040",
        "fa-percent": "\uf295",
        "fa-phone-square": "\uf098",
        "fa-phone": "\uf095",
        "fa-photo": "\uf03e",
        "fa-picture-o": "\uf03e",
        "fa-pie-chart": "\uf200",
        "fa-plane": "\uf072",
        "fa-play-circle-o": "\uf01d",
        "fa-play-circle": "\uf144",
        "fa-play": "\uf04b",
        "fa-plug": "\uf1e6",
        "fa-plus-circle": "\uf055",
        "fa-plus-square-o": "\uf196",
        "fa-plus-square": "\uf0fe",
        "fa-plus": "\uf067",
        "fa-podcast": "\uf2ce",
        "fa-power-off": "\uf011",
        "fa-print": "\uf02f",
        "fa-puzzle-piece": "\uf12e",
        "fa-qrcode": "\uf029",
        "fa-question-circle-o": "\uf29c",
        "fa-question-circle": "\uf059",
        "fa-question": "\uf128",
        "fa-quote-left": "\uf10d",
        "fa-quote-right": "\uf10e",
        "fa-random": "\uf074",
        "fa-recycle": "\uf1b8",
        "fa-refresh": "\uf021",
        "fa-registered": "\uf25d",
        "fa-remove": "\uf00d",
        "fa-reorder": "\uf0c9",
        "fa-repeat": "\uf01e",
        "fa-reply-all": "\uf122",
        "fa-reply": "\uf112",
        "fa-retweet": "\uf079",
        "fa-rmb": "\uf157",
        "fa-road": "\uf018",
        "fa-rocket": "\uf135",
        "fa-rotate-left": "\uf0e2",
        "fa-rotate-right": "\uf01e",
        "fa-rouble": "\uf158",
        "fa-rss-square": "\uf143",
        "fa-rss": "\uf09e",
        "fa-rub": "\uf158",
        "fa-ruble": "\uf158",
        "fa-rupee": "\uf156",
        "fa-s15": "\uf2cd",
        "fa-save": "\uf0c7",
        "fa-scissors": "\uf0c4",
        "fa-search-minus": "\uf010",
        "fa-search-plus": "\uf00e",
        "fa-search": "\uf002",
        "fa-send-o": "\uf1d9",
        "fa-send": "\uf1d8",
        "fa-server": "\uf233",
        "fa-share-square-o": "\uf045",
        "fa-share-square": "\uf14d",
        "fa-share": "\uf064",
        "fa-shekel": "\uf20b",
        "fa-sheqel": "\uf20b",
        "fa-shield": "\uf132",
        "fa-ship": "\uf21a",
        "fa-shopping-bag": "\uf290",
        "fa-shopping-basket": "\uf291",
        "fa-shopping-cart": "\uf07a",
        "fa-shower": "\uf2cc",
        "fa-sign-in": "\uf090",
        "fa-sign-language": "\uf2a7",
        "fa-sign-out": "\uf08b",
        "fa-signal": "\uf012",
        "fa-signing": "\uf2a7",
        "fa-sitemap": "\uf0e8",
        "fa-sliders": "\uf1de",
        "fa-smile-o": "\uf118",
        "fa-snowflake-o": "\uf2dc",
        "fa-soccer-ball-o": "\uf1e3",
        "fa-sort-alpha-asc": "\uf15d",
        "fa-sort-alpha-desc": "\uf15e",
        "fa-sort-amount-asc": "\uf160",
        "fa-sort-amount-desc": "\uf161",
        "fa-sort-asc": "\uf0de",
        "fa-sort-desc": "\uf0dd",
        "fa-sort-down": "\uf0dd",
        "fa-sort-numeric-asc": "\uf162",
        "fa-sort-numeric-desc": "\uf163",
        "fa-sort-up": "\uf0de",
        "fa-sort": "\uf0dc",
        "fa-space-shuttle": "\uf197",
        "fa-spinner": "\uf110",
        "fa-spoon": "\uf1b1",
        "fa-square-o": "\uf096",
        "fa-square": "\uf0c8",
        "fa-star-half-empty": "\uf123",
        "fa-star-half-full": "\uf123",
        "fa-star-half-o": "\uf123",
        "fa-star-half": "\uf089",
        "fa-star-o": "\uf006",
        "fa-star": "\uf005",
        "fa-step-backward": "\uf048",
        "fa-step-forward": "\uf051",
        "fa-stethoscope": "\uf0f1",
        "fa-sticky-note-o": "\uf24a",
        "fa-sticky-note": "\uf249",
        "fa-stop-circle-o": "\uf28e",
        "fa-stop-circle": "\uf28d",
        "fa-stop": "\uf04d",
        "fa-street-view": "\uf21d",
        "fa-strikethrough": "\uf0cc",
        "fa-subscript": "\uf12c",
        "fa-subway": "\uf239",
        "fa-suitcase": "\uf0f2",
        "fa-sun-o": "\uf185",
        "fa-superscript": "\uf12b",
        "fa-support": "\uf1cd",
        "fa-table": "\uf0ce",
        "fa-tablet": "\uf10a",
        "fa-tachometer": "\uf0e4",
        "fa-tag": "\uf02b",
        "fa-tags": "\uf02c",
        "fa-tasks": "\uf0ae",
        "fa-taxi": "\uf1ba",
        "fa-television": "\uf26c",
        "fa-terminal": "\uf120",
        "fa-text-height": "\uf034",
        "fa-text-width": "\uf035",
        "fa-th-large": "\uf009",
        "fa-th-list": "\uf00b",
        "fa-th": "\uf00a",
        "fa-thermometer-0": "\uf2cb",
        "fa-thermometer-1": "\uf2ca",
        "fa-thermometer-2": "\uf2c9",
        "fa-thermometer-3": "\uf2c8",
        "fa-thermometer-4": "\uf2c7",
        "fa-thermometer-empty": "\uf2cb",
        "fa-thermometer-full": "\uf2c7",
        "fa-thermometer-half": "\uf2c9",
        "fa-thermometer-quarter": "\uf2ca",
        "fa-thermometer-three-quarters": "\uf2c8",
        "fa-thermometer": "\uf2c7",
        "fa-thumb-tack": "\uf08d",
        "fa-thumbs-down": "\uf165",
        "fa-thumbs-o-down": "\uf088",
        "fa-thumbs-o-up": "\uf087",
        "fa-thumbs-up": "\uf164",
        "fa-ticket": "\uf145",
        "fa-times-circle-o": "\uf05c",
        "fa-times-circle": "\uf057",
        "fa-times-rectangle-o": "\uf2d4",
        "fa-times-rectangle": "\uf2d3",
        "fa-times": "\uf00d",
        "fa-tint": "\uf043",
        "fa-toggle-down": "\uf150",
        "fa-toggle-left": "\uf191",
        "fa-toggle-off": "\uf204",
        "fa-toggle-on": "\uf205",
        "fa-toggle-right": "\uf152",
        "fa-toggle-up": "\uf151",
        "fa-trademark": "\uf25c",
        "fa-train": "\uf238",
        "fa-transgender-alt": "\uf225",
        "fa-transgender": "\uf224",
        "fa-trash-o": "\uf014",
        "fa-trash": "\uf1f8",
        "fa-tree": "\uf1bb",
        "fa-trophy": "\uf091",
        "fa-truck": "\uf0d1",
        "fa-try": "\uf195",
        "fa-tty": "\uf1e4",
        "fa-turkish-lira": "\uf195",
        "fa-tv": "\uf26c",
        "fa-umbrella": "\uf0e9",
        "fa-underline": "\uf0cd",
        "fa-undo": "\uf0e2",
        "fa-universal-access": "\uf29a",
        "fa-university": "\uf19c",
        "fa-unlink": "\uf127",
        "fa-unlock-alt": "\uf13e",
        "fa-unlock": "\uf09c",
        "fa-unsorted": "\uf0dc",
        "fa-upload": "\uf093",
        "fa-usd": "\uf155",
        "fa-user-circle-o": "\uf2be",
        "fa-user-circle": "\uf2bd",
        "fa-user-md": "\uf0f0",
        "fa-user-o": "\uf2c0",
        "fa-user-plus": "\uf234",
        "fa-user-secret": "\uf21b",
        "fa-user-times": "\uf235",
        "fa-user": "\uf007",
        "fa-users": "\uf0c0",
        "fa-vcard-o": "\uf2bc",
        "fa-vcard": "\uf2bb",
        "fa-venus-double": "\uf226",
        "fa-venus-mars": "\uf228",
        "fa-venus": "\uf221",
        "fa-video-camera": "\uf03d",
        "fa-volume-control-phone": "\uf2a0",
        "fa-volume-down": "\uf027",
        "fa-volume-off": "\uf026",
        "fa-volume-up": "\uf028",
        "fa-warning": "\uf071",
        "fa-wheelchair-alt": "\uf29b",
        "fa-wheelchair": "\uf193",
        "fa-wifi": "\uf1eb",
        "fa-window-close-o": "\uf2d4",
        "fa-window-close": "\uf2d3",
        "fa-window-maximize": "\uf2d0",
        "fa-window-minimize": "\uf2d1",
        "fa-window-restore": "\uf2d2",
        "fa-won": "\uf159",
        "fa-wrench": "\uf0ad",
        "fa-yen": "\uf157"
    };

    var brandIconMap = {
        "fa-500px": "\uf26e",
        "fa-adn": "\uf170",
        "fa-amazon": "\uf270",
        "fa-android": "\uf17b",
        "fa-angellist": "\uf209",
        "fa-apple": "\uf179",
        "fa-bandcamp": "\uf2d5",
        "fa-behance-square": "\uf1b5",
        "fa-behance": "\uf1b4",
        "fa-bitbucket-square": "\uf172",
        "fa-bitbucket": "\uf171",
        "fa-bitcoin": "\uf15a",
        "fa-black-tie": "\uf27e",
        "fa-bluetooth-b": "\uf294",
        "fa-bluetooth": "\uf293",
        "fa-btc": "\uf15a",
        "fa-buysellads": "\uf20d",
        "fa-cc-amex": "\uf1f3",
        "fa-cc-diners-club": "\uf24c",
        "fa-cc-discover": "\uf1f2",
        "fa-cc-jcb": "\uf24b",
        "fa-cc-mastercard": "\uf1f1",
        "fa-cc-paypal": "\uf1f4",
        "fa-cc-stripe": "\uf1f5",
        "fa-cc-visa": "\uf1f0",
        "fa-chrome": "\uf268",
        "fa-codepen": "\uf1cb",
        "fa-codiepie": "\uf284",
        "fa-connectdevelop": "\uf20e",
        "fa-contao": "\uf26d",
        "fa-css3": "\uf13c",
        "fa-dashcube": "\uf210",
        "fa-delicious": "\uf1a5",
        "fa-deviantart": "\uf1bd",
        "fa-digg": "\uf1a6",
        "fa-dribbble": "\uf17d",
        "fa-dropbox": "\uf16b",
        "fa-drupal": "\uf1a9",
        "fa-edge": "\uf282",
        "fa-eercast": "\uf2da",
        "fa-empire": "\uf1d1",
        "fa-envira": "\uf299",
        "fa-etsy": "\uf2d7",
        "fa-expeditedssl": "\uf23e",
        "fa-fa": "\uf2b4",
        "fa-facebook-f": "\uf09a",
        "fa-facebook-official": "\uf230",
        "fa-facebook-square": "\uf082",
        "fa-facebook": "\uf09a",
        "fa-firefox": "\uf269",
        "fa-first-order": "\uf2b0",
        "fa-flickr": "\uf16e",
        "fa-font-awesome": "\uf2b4",
        "fa-fonticons": "\uf280",
        "fa-fort-awesome": "\uf286",
        "fa-forumbee": "\uf211",
        "fa-foursquare": "\uf180",
        "fa-free-code-camp": "\uf2c5",
        "fa-ge": "\uf1d1",
        "fa-get-pocket": "\uf265",
        "fa-gg-circle": "\uf261",
        "fa-gg": "\uf260",
        "fa-git-square": "\uf1d2",
        "fa-git": "\uf1d3",
        "fa-github-alt": "\uf113",
        "fa-github-square": "\uf092",
        "fa-github": "\uf09b",
        "fa-gitlab": "\uf296",
        "fa-gittip": "\uf184",
        "fa-glide-g": "\uf2a6",
        "fa-glide": "\uf2a5",
        "fa-google-plus-circle": "\uf2b3",
        "fa-google-plus-official": "\uf2b3",
        "fa-google-plus-square": "\uf0d4",
        "fa-google-plus": "\uf0d5",
        "fa-google-wallet": "\uf1ee",
        "fa-google": "\uf1a0",
        "fa-gratipay": "\uf184",
        "fa-grav": "\uf2d6",
        "fa-hacker-news": "\uf1d4",
        "fa-houzz": "\uf27c",
        "fa-html5": "\uf13b",
        "fa-imdb": "\uf2d8",
        "fa-instagram": "\uf16d",
        "fa-internet-explorer": "\uf26b",
        "fa-ioxhost": "\uf208",
        "fa-joomla": "\uf1aa",
        "fa-jsfiddle": "\uf1cc",
        "fa-lastfm-square": "\uf203",
        "fa-lastfm": "\uf202",
        "fa-leanpub": "\uf212",
        "fa-linkedin-square": "\uf08c",
        "fa-linkedin": "\uf0e1",
        "fa-linode": "\uf2b8",
        "fa-linux": "\uf17c",
        "fa-maxcdn": "\uf136",
        "fa-meanpath": "\uf20c",
        "fa-medium": "\uf23a",
        "fa-meetup": "\uf2e0",
        "fa-mixcloud": "\uf289",
        "fa-modx": "\uf285",
        "fa-odnoklassniki-square": "\uf264",
        "fa-odnoklassniki": "\uf263",
        "fa-opencart": "\uf23d",
        "fa-openid": "\uf19b",
        "fa-opera": "\uf26a",
        "fa-optin-monster": "\uf23c",
        "fa-pagelines": "\uf18c",
        "fa-paypal": "\uf1ed",
        "fa-pied-piper-alt": "\uf1a8",
        "fa-pied-piper-pp": "\uf1a7",
        "fa-pied-piper": "\uf2ae",
        "fa-pinterest-p": "\uf231",
        "fa-pinterest-square": "\uf0d3",
        "fa-pinterest": "\uf0d2",
        "fa-product-hunt": "\uf288",
        "fa-qq": "\uf1d6",
        "fa-quora": "\uf2c4",
        "fa-ra": "\uf1d0",
        "fa-ravelry": "\uf2d9",
        "fa-rebel": "\uf1d0",
        "fa-reddit-alien": "\uf281",
        "fa-reddit-square": "\uf1a2",
        "fa-reddit": "\uf1a1",
        "fa-renren": "\uf18b",
        "fa-resistance": "\uf1d0",
        "fa-safari": "\uf267",
        "fa-scribd": "\uf28a",
        "fa-sellsy": "\uf213",
        "fa-share-alt-square": "\uf1e1",
        "fa-share-alt": "\uf1e0",
        "fa-shirtsinbulk": "\uf214",
        "fa-simplybuilt": "\uf215",
        "fa-skyatlas": "\uf216",
        "fa-skype": "\uf17e",
        "fa-slack": "\uf198",
        "fa-slideshare": "\uf1e7",
        "fa-snapchat-ghost": "\uf2ac",
        "fa-snapchat-square": "\uf2ad",
        "fa-snapchat": "\uf2ab",
        "fa-soundcloud": "\uf1be",
        "fa-spotify": "\uf1bc",
        "fa-stack-exchange": "\uf18d",
        "fa-stack-overflow": "\uf16c",
        "fa-steam-square": "\uf1b7",
        "fa-steam": "\uf1b6",
        "fa-stumbleupon-circle": "\uf1a3",
        "fa-stumbleupon": "\uf1a4",
        "fa-superpowers": "\uf2dd",
        "fa-telegram": "\uf2c6",
        "fa-tencent-weibo": "\uf1d5",
        "fa-themeisle": "\uf2b2",
        "fa-trello": "\uf181",
        "fa-tripadvisor": "\uf262",
        "fa-tumblr-square": "\uf174",
        "fa-tumblr": "\uf173",
        "fa-twitch": "\uf1e8",
        "fa-twitter-square": "\uf081",
        "fa-twitter": "\uf099",
        "fa-usb": "\uf287",
        "fa-viacoin": "\uf237",
        "fa-viadeo-square": "\uf2aa",
        "fa-viadeo": "\uf2a9",
        "fa-vimeo-square": "\uf194",
        "fa-vimeo": "\uf27d",
        "fa-vine": "\uf1ca",
        "fa-vk": "\uf189",
        "fa-wechat": "\uf1d7",
        "fa-weibo": "\uf18a",
        "fa-weixin": "\uf1d7",
        "fa-whatsapp": "\uf232",
        "fa-wikipedia-w": "\uf266",
        "fa-windows": "\uf17a",
        "fa-wordpress": "\uf19a",
        "fa-wpbeginner": "\uf297",
        "fa-wpexplorer": "\uf2de",
        "fa-wpforms": "\uf298",
        "fa-xing-square": "\uf169",
        "fa-xing": "\uf168",
        "fa-y-combinator-square": "\uf1d4",
        "fa-y-combinator": "\uf23b",
        "fa-yahoo": "\uf19e",
        "fa-yc-square": "\uf1d4",
        "fa-yc": "\uf23b",
        "fa-yelp": "\uf1e9",
        "fa-yoast": "\uf2b1",
        "fa-youtube-play": "\uf16a",
        "fa-youtube-square": "\uf166",
        "fa-youtube": "\uf167",
    };

    var iconList = Object.keys(iconMap);

    return {
        getIconUnicode: function(name) {
            return iconMap[name] || brandIconMap[name];
        },
        getIconList: function() {
            return iconList;
        },
    }
})();
