/*
MIT License

Copyright (c) 2019, 2020 Steve-Mcl

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

var util = require("util");
const mcprotocol = require('./mcprotocol/mcprotocol.js');

var pool = {};

module.exports = {
  get: function(port, host, opts) {
    var mcprotocol = require("./mcprotocol/mcprotocol.js");
    var id = `mcprotocol: {host:'${host || ""}', port: ${port || "''"}}`;
    //var id = `mcprotocol: {host:'${(host || "")}', port: ${(port || "''")}, frame:'${frame}', plcType:'${plcType}}`;
    var node = this;

    if (!pool[id]) {
      pool[id] = (function() {
        var options = opts || {};
        options.host = host;
        options.port = port;
        options.protocol = options.protocol || "TCP";
        options.ascii = options.ascii || false;
        options.frame = options.frame || "3E";
        options.plcType = options.plcType || "Q";
        options.autoConnect = true;
        options.preventAutoReconnect = false;
        options.logLevel = options.logLevel || "WARN";
        util.log(`[mcprotocol] adding new connection to pool ~ ${id}`);

        var mcp = new mcprotocol();

        mcp.setDebugLevel(options.logLevel);
        mcp.initiateConnection(options);
        var connecting = false;
        var connected = true;
        var times = 0;
        var obj = {
          getMCP: function mcp() {
            return mcp;
          },
          getAutoConnect: function() {
            return options.autoConnect == true;
          },
          setAutoConnect: function(b) {
            options.autoConnect = b == true;
          },
          _instances: 0,
          write: function(addr, data, callback) {
            if (!mcp.isConnected()) {
              //this.connect();
              throw new Error("Not connected!");
            }
            var reply = mcp.writeItems(addr, data, callback);
            return reply;
          },
          read: function(addr, callback) {
            // util.log(`isConnected -- ${mcp.isConnected()}`)
            // util.log(`mcp.isConnected: ${mcp.isConnected()} ---connected: ${connected}`)
            if (!mcp.isConnected()) {
              //this.connect();
              throw new Error("Not connected!");
            }
            var reply = mcp.readItems(addr, callback);
            return reply;
          },
          closeConnection: function() {
            mcp.connectionReset();
            // options.preventAutoReconnect = true;
          },
          on: function(a, b) {
            mcp.on(a, b);
          },
          closeMcp: function () {
            // util.log('close mcp');
            if (mcp) {
              mcp.close();
            }
          },
          // connect: function() {
          //   options.preventAutoReconnect = false;
          //   if (mcp && !mcp.isConnected() && !connecting) {
          //     connecting = true;
          //     try {
          //       mcp.initiateConnection(options);
          //     } catch (e) {
          //       util.log(`[connect] e ${e}`)
          //     }
          //   }
          // },
          // disconnect: function() {
          //   this._instances -= 1;
          //   if (this._instances <= 0) {
          //     util.log(`[mcprotocol] closing connection ~ ${id}`);
          //     mcp.dropConnection();
          //     mcp = null;
          //     util.log(`[mcprotocol] deleting connection from pool ~ ${id}`);
          //     delete pool[id];
          //   }
          // },
          // reinitialize: function() {
          //   //in case of physical connection loss, it does not get the connection back
          //   //when connecting again. the mcp object needs to be renewed.
          //   // this.disconnect();
          //   if (mcp) {
          //     if (mcp.isConnected() && times > 0) {
          //       util.log('[reinitialize] connected')
          //       return;
          //     }
          //     util.log('[reinitialize] drop mcp')
          //     mcp.dropConnection();
          //     // mcp = null;
          //     delete pool[id];
          //   }
          //
          //   // mcp = new mcprotocol();
          //   // mcp.on('error', function (e) {
          //   //   connected = false;
          //   //   connecting = false;
          //   //   util.log(`[mcprotocol - reinitialize] error ~ ${id}: ${e}`);
          //   // });
          //   // mcp.on('open', function () {
          //   //   connected = true;
          //   //   connecting = false;
          //   //   times = 0;
          //   //   util.log(`[mcprotocol - reinitialize] open ~ ${id}`);
          //   // });
          //   // mcp.on('close', function (e) {
          //   //   connected = false;
          //   //   connecting = false;
          //   //   util.log(`[mcprotocol - reinitialize] close ~ ${id}`);
          //   // });
          //   connecting = false;
          //   connected = false;
          //   this.connect();
          //   times++;
          //   // this._instances += 1;
          // },
          connect: function() {
            options.preventAutoReconnect = false;
            if (mcp && !mcp.isConnected() && !connecting) {
              connecting = true;
              mcp.initiateConnection(options);
            }
          },
          disconnect: function() {
            this._instances -= 1;
            mcp.dropConnection();
            delete pool[id];
            // if (this._instances <= 0) {
            //   util.log(`[mcprotocol] closing connection ~ ${id}`);
            //   mcp.dropConnection();
            //   mcp = null;
            //   util.log(`[mcprotocol] deleting connection from pool ~ ${id}`);
            //   delete pool[id];
            // }
          },
          reinitialize: function() {
            //in case of physical connection loss, it does not get the connection back
            //when connecting again. the mcp object needs to be renewed.
            this.disconnect();
            if (!mcp) {
              mcp = new mcprotocol();
              connecting = false;
            }
            this.connect();
            // this._instances += 1;
          },
          addTimeoutTimes: function () {
            times++;
            // util.log(`times -- ${times}`);
            if (times > 1) {
              times = 0;
              this.closeConnection();
              // this.dropConnection();
            }
          },

        };

        mcp.on("error", function(e) {
          util.log(`[mcprotocol] error ~`);
          if (mcp) {
            util.log(`[mcprotocol] error ~ ${id}: ${e}`);
            connecting = false;
            connected = false;
            if (options.autoConnect) {
              setTimeout(function() {
                if (options.autoConnect && !options.preventAutoReconnect) {
                  util.log(
                      `[mcprotocol] autoConnect call from  error handler ~ ${id}`
                  );
                  obj.connect();
                }
              }, 1000); //parametrise
            }
          }
        });
        mcp.on("open", function() {
          if (mcp) {
            util.log(`[mcprotocol] open connected ~ ${id}`);
            connecting = false;
            connected = true;
          }
        });
        mcp.on("close", function(err) {
          util.log(`[mcprotocol] connection closed ~ ${id}`);
          connecting = false;
          connected = false;
          if (options.autoConnect) {
            setTimeout(function() {
              if (options.autoConnect && !options.preventAutoReconnect) {
                util.log(
                    `[mcprotocol] autoConnect call from close handler ~ ${id}`
                );
                obj.connect();
              }
            }, 1000); //parametrise
          }
        });

        return obj;
      })();
    }
    pool[id]._instances += 1;
    return pool[id];
  }
};
