const aedes = require('aedes')();
const server = require('net').createServer(aedes.handle);
const PORT = 10883;

server.listen(PORT, function () {
  console.log(`MQTT server is running on port ${PORT}`);
});

aedes.on('client', (client) => {
  console.log(`Client Connected: ${client.id}`);
});

aedes.on('clientDisconnect', (client) => {
  console.log(`Client Disconnected: ${client.id}`);
});

aedes.on('publish', (packet, client) => {
  console.log(`Message Published: ${packet.payload.toString()}`);
});
