function logout() {

}

function checkStatus(status, msg) {
  let errMessage = ""

  switch (status) {
    case 400:
      errMessage = `${msg}`
      break
    // 401: Not logged in
    // Jump to the login page if not logged in, and carry the path of the current page
    // Return to the current page after successful login. This step needs to be operated on the login page.
    case 401:
      errMessage = msg || t("api.errMsg401")
      logout()
      break
    case 403:
      errMessage = RED._("api.errMsg403")
      break
    // 404请求不存在
    case 404:
      errMessage = RED._("api.errMsg404")
      break
    case 405:
      errMessage = RED._("api.errMsg405")
      break
    case 408:
      errMessage = RED._("api.errMsg408")
      break
    case 500:
      errMessage = RED._("api.errMsg500")
      break
    case 501:
      errMessage = RED._("api.errMsg501")
      break
    case 502:
      errMessage = RED._("api.errMsg502")
      break
    case 503:
      errMessage = RED._("api.errMsg503")
      break
    case 504:
      errMessage = RED._("api.errMsg504")
      break
    case 505:
      errMessage = RED._("api.errMsg505")
      break
    default:
  }

  if (errMessage)
    RED.notifications.notify(errMessage, 'error')
}
