const { join } = require('path')
const { cwd } = require('process')

module.exports = {
  /**
    * @description Server active port
    */
  port: 3002,

  /**
   * @description Node red server exec path
   */
  nodeRedServerExecPath: join(
    cwd(),
    './node-red/packages/node_modules/node-red/red.js',
  ),

  /**
   * @description Node red default settings path
   */
  nodeRedBaseSettingsPath: join(cwd(), './settings.js'),

  /**
   * @description Data base save path
   */
  databasePath: join(cwd(), './database'),

  /**
   * @description Common node dir
   */
  commonNodeDir: join(cwd(), './commonNode'),


  /**
   * @description Entity service running port range
   */
  entityServicePortRange: [1900, 2000],

  /**
   * @description Max entity count
   */
  maxEntityCount: 10,

  /**
   * @description Protocol template common dir path
   */
  protocolTemplateDir: join(cwd() , './protocol-template')
}
