// coap_server.js
const coap = require('coap');
const server = coap.createServer();

server.on('request', (req, res) => {
  console.log(`Received ${req.method} request on ${req.url}`);

  console.log("method:",req.method);

 if (req.method === 'POST') {
    let payload = {data:"123"};
    req.on('data', chunk => {
      payload += chunk;
    });
    req.on('end', () => {
      console.log('Payload:', payload);
      res.end('POST received with payload: ' + payload);
    });
  } else {
    res.end('Only POST is supported in this example.');
  }
});

server.listen(() => {
  console.log('CoAP server listening on port 5683...');
});

