import { createStore } from 'vuex'

export default createStore({
  state: {
    // 应用状态
    isDarkMode: false,
    userInfo: null,
    currentTab: 'chats'
  },
  mutations: {
    // 同步状态修改
    SET_DARK_MODE(state, isDarkMode) {
      state.isDarkMode = isDarkMode
    },
    SET_USER_INFO(state, userInfo) {
      state.userInfo = userInfo
    },
    SET_CURRENT_TAB(state, tab) {
      state.currentTab = tab
    }
  },
  actions: {
    // 异步操作
    toggleDarkMode({ commit, state }) {
      const newMode = !state.isDarkMode
      commit('SET_DARK_MODE', newMode)
      localStorage.setItem('isDarkMode', newMode)
    },
    loadUserInfo({ commit }) {
      const savedUser = localStorage.getItem('username')
      if (savedUser) {
        commit('SET_USER_INFO', { username: savedUser })
      }
    }
  },
  getters: {
    // 状态计算
    isLoggedIn: state => !!state.userInfo,
    username: state => state.userInfo?.username || '管理员'
  }
})
