import { createRouter, createWebHistory } from 'vue-router'

// 创建布局组件
const Layout = () => import('../pages/Layout.vue')

// 优化后的路由结构
const routes = [
  {
    path: '/',
    component: Layout, // 使用专门的布局组件
    redirect: '/knowledge-base',
    children: [
      {
        path: '/knowledge-base',
        name: 'KnowledgeBase',
        component: () => import('../pages/chats.vue'),
        meta: { title: '知识库', icon: '💬' }
      },
      {
        path: '/knowledge-graph',
        name: 'KnowledgeGraph',
        component: () => import('../pages/graph.vue'),
        meta: { title: '知识图谱', icon: '📊' },
        redirect: '/knowledge-graph/2d',
        children: [
          {
            path: '2d',
            name: 'KnowledgeGraph2D',
            component: () => import('../pages/components/2dView.vue'),
            meta: { title: '2D知识图谱' }
          },
          {
            path: '3d',
            name: 'KnowledgeGraph3D',
            component: () => import('../pages/components/3dView.vue'),
            meta: { title: '3D知识图谱' }
          }
        ]
      }
    ]
  },
  
  // 兼容旧路由的重定向
  {
    path: '/chats',
    redirect: '/knowledge-base'
  },
  {
    path: '/graph',
    redirect: '/knowledge-graph'
  },
  {
    path: '/2dView',
    redirect: '/knowledge-graph/2d'
  },
  {
    path: '/3dView',
    redirect: '/knowledge-graph/3d'
  },
  
  // 404页面
  {
    path: '/:pathMatch(.*)*',
    name: 'NotFound',
    component: () => import('../pages/chats.vue') // 暂时使用知识库页面作为404页面
  }
]

const router = createRouter({
  history: createWebHistory(),
  routes
})

// 路由守卫
router.beforeEach((to, from, next) => {
  // 设置页面标题
  if (to.meta && to.meta.title) {
    document.title = `${to.meta.title} - 长沙伊测电子科技`
  }
  
  // 检查权限（可以在这里添加登录验证逻辑）
  const isAuthenticated = localStorage.getItem('token') || true // 暂时允许所有访问
  
  if (!isAuthenticated && to.path !== '/login') {
    next('/login')
  } else {
    next()
  }
})

export default router
