// 简单的依赖安装脚本
import fs from 'fs';
import path from 'path';

// 读取package.json
const packageJson = JSON.parse(fs.readFileSync('package.json', 'utf8'));

console.log('检查依赖...');

// 检查关键依赖是否存在
const requiredDeps = [
  '@vitejs/plugin-vue',
  'vue',
  'vue-router',
  'vuex'
];

let missingDeps = [];

requiredDeps.forEach(dep => {
  const depPath = path.join('node_modules', dep);
  if (!fs.existsSync(depPath)) {
    missingDeps.push(dep);
  }
});

if (missingDeps.length > 0) {
  console.log('缺失的依赖:', missingDeps);
  console.log('请手动安装这些依赖');
} else {
  console.log('所有关键依赖都已安装');
}

// 创建简单的vite配置备用
const viteConfigBackup = `
import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'

export default defineConfig({
  plugins: [vue()],
  server: {
    port: 5174
  }
})
`;

fs.writeFileSync('vite.config.backup.js', viteConfigBackup);
console.log('创建了备用vite配置文件');